<?php
		global $vc_version, $vc_path;
		if (isset($_POST['info_update'])) { ?>
			<div id="message" class="updated fade"><p><strong>
			<?php
				// Verifying passed data
				if( !isset($_POST['vc_tag']) || ("" == $_POST['vc_tag']) )
				{
					echo "<strong style='color:red;'>Warning:</strong> Tag needs to be set. Using previous value.<br/>";
					$vc_error = 1;
				}
				else
				{
					update_option('vc_tag', $_POST['vc_tag']);
				}
				update_option('vc_text_before', $_POST['vc_text_before']);
				update_option('vc_human_count_text_1', $_POST['vc_human_count_text_1']);
				update_option('vc_human_count_text_many', $_POST['vc_human_count_text_many']);
				update_option('vc_preposition', $_POST['vc_preposition']);
				update_option('vc_display_views', $_POST['vc_display_views']);
				update_option('vc_human_viewers_text_1', $_POST['vc_human_viewers_text_1']);
				update_option('vc_human_viewers_text_many', $_POST['vc_human_viewers_text_many']);
				update_option('vc_count_main_page_views', $_POST['vc_count_main_page_views']);
				update_option('vc_display_icon', $_POST['vc_display_icon']);
				update_option('vc_show_in_posts_listing', $_POST['vc_show_in_posts_listing']);
				update_option('vc_command_line', $_POST['vc_command_line']);
				echo "Views Counter options saved" . (isset($vc_error) ? "" : " successfully") . ". <a href='" . get_bloginfo('wpurl') . "' target='_blank'>View site &rarr;</a>";
			?>
			</strong></p></div>
		<?php } ?>
		<div class="wrap">
			<form method="post">
				<h2>Views Counter Settings</h2>
				<div style="padding:20px;">
					<em>Views Counter v.<?= $vc_version ?></em> (VC) helps you to track easily the total number
					of visitors viewed your post pages and number of views by itself. VC could be used in two ways:<br/>
					<ul>
						<li><em>Standard</em> - you just set some settings below and turn VC on;</li>
						<li><em>Through the function</em> - this way is much advanced and flexible, but needs the correction
						of your theme's templates.</li>
					</ul>
					After activating of VC you'll see at every post page such a string (<em>using your current settings</em>):
					<ul>
						<li>
							For 1 view by 1 visitor:
							<blockquote style="background-color:#f0f8ff;border-top:#cccccc 1px solid;border-bottom:#cccccc 1px solid;">
								<?=
									implode(
													array( get_option('vc_text_before'),
													1,
													get_option('vc_human_count_text_1'),
													get_option('vc_preposition'),
													1,
													get_option('vc_human_viewers_text_1')
													),
													"&nbsp;"
													);
								?>
							</blockquote>
						</li>
					</ul>
					<ul>
						<li>
							For many views (e.g., 5) by 1 visitor:
							<blockquote style="background-color:#f0f8ff;border-top:#cccccc 1px solid;border-bottom:#cccccc 1px solid;">
								<?=
									implode(
													array( get_option('vc_text_before'),
													5,
													get_option('vc_human_count_text_many'),
													get_option('vc_preposition'),
													1,
													get_option('vc_human_viewers_text_1')
													),
													"&nbsp;"
													);
								?>
							</blockquote>
						</li>
					</ul>
					<ul>
						<li>
							For many views (e.g., 45) by many visitors (e.g., 13):
							<blockquote style="background-color:#f0f8ff;border-top:#cccccc 1px solid;border-bottom:#cccccc 1px solid;">
								<?=
									implode(
													array( get_option('vc_text_before'),
													45,
													get_option('vc_human_count_text_many'),
													get_option('vc_preposition'),
													13,
													get_option('vc_human_viewers_text_many')
													),
													"&nbsp;"
													);
								?>
							</blockquote>
						</li>
					</ul>
				</div>
				<hr/>
				<p><fieldset name="general">
					<legend><strong>General options</strong></legend>
					<ul>
						<li>
							Do you want statistics to be displayed at your weblog?
							<p style="background-color:#f0f8ff;">
								<input
									type="radio"
									name="vc_display_views"
									id="vc_dv_yeah"
									value="1"
									<?php if(1 == get_option('vc_display_views')) echo 'checked="checked"'; ?>
								/>
								<label for="vc_dv_yeah">Of course. I need it to be easy.</label>
							</p>
							<p style="background-color:#f0f8ff;">
								<input
									type="radio"
									name="vc_display_views"
									id="vc_dv_nope"
									value="0"
									<?php if(1 != get_option('vc_display_views')) echo 'checked="checked"'; ?>
								/>
								<label for="vc_dv_nope">Nope. I'll use the <span style="font-family:monospace;">vc_get_stats</span> function in my theme.</label>
							</p>
						</li>
						<li>
							Should I also display and track views of posts on the main page?
							<p style="background-color:#f0f8ff;">
								<input
									type="radio"
									name="vc_count_main_page_views"
									id="vc_cmpv_yeah"
									value="1"
									<?php if(1 == get_option('vc_count_main_page_views')) echo 'checked="checked"'; ?>
								/>
								<label for="vc_cmpv_yeah">Yeah, for sure!</label>
							</p>
							<p style="background-color:#f0f8ff;">
								<input
									type="radio"
									name="vc_count_main_page_views"
									id="vc_cmpv_nope"
									value="0"
									<?php if(1 != get_option('vc_count_main_page_views')) echo 'checked="checked"'; ?>
								/>
								<label for="vc_cmpv_nope">Man, leave it. There's no need.</label>
							</p>
						</li>
						<li>
							May I place the small logo icon at the beginning of the line to thank the author of the plugin? It looks like this: <?= vc_get_icon() ?>
							<p style="background-color:#f0f8ff;">
								<input
									type="radio"
									name="vc_display_icon"
									id="vc_di_yeah"
									value="1"
									<?php if(1 == get_option('vc_display_icon')) echo 'checked="checked"'; ?>
								/>
								<label for="vc_di_yeah">A-ha. (Thank you)</label>
							</p>
							<p style="background-color:#f0f8ff;">
								<input
									type="radio"
									name="vc_display_icon"
									id="vc_di_nope"
									value="0"
									<?php if(1 != get_option('vc_display_icon')) echo 'checked="checked"'; ?>
								/>
								<label for="vc_di_nope">No, no and once more no. I dont't want any little pretty icon at my pages.</label>
							</p>
						</li>
					</ul>
				</fieldset></p>
				<p><fieldset name="text">
					<legend><strong>Text parsing options</strong></legend>
					<ul>
						<li>
							<label for="vc_tag">Tag:</label>
							<input
								name="vc_tag"
								id="vc_tag"
								value="<?= get_option('vc_tag') ?>"
								type="text"
							/>
							<em>the tag in which output text will be enclosed; e.g., "p"</em>
						</li>
					</ul>
					<ul>
						<li>
							<label for="vc_text_before">Text set before the number of views:</label>
							<input
								type="text"
								name="vc_text_before"
								id="vc_text_before"
								value="<?= get_option('vc_text_before') ?>"
							/>
							<em>e.g., "Viewed"</em>
						</li>
						<li>Text set directly after the number of views:
							<p>&mdash;
									<label for="vc_human_count_text_1">in case of 1 view:</label>
									<input
										type="text"
										name="vc_human_count_text_1"
										id="vc_human_count_text_1"
										value="<?= get_option('vc_human_count_text_1') ?>"
									/>
									<em>e.g., "time"</em>
							</p>
							<p>&mdash;
									<label for="vc_human_count_text_many">in case of lots of views:</label>
									<input
										type="text"
										name="vc_human_count_text_many"
										id="vc_human_count_text_many"
										value="<?= get_option('vc_human_count_text_many') ?>"
									/>
									<em>e.g., "times"</em>
							</p>
						</li>
						<li>
							<label for="vc_preposition">Preposition before the number of visitors:</label>
							<input
								type="text"
								name="vc_preposition"
								id="vc_preposition"
								value="<?= get_option('vc_preposition') ?>"
							/>
							<em>depends on the language; e.g., in the English may be set to "by"</em>
						</li>
						<li>Text set directly after the number of visitors:
							<p>&mdash;
									<label for="vc_human_viewers_text_1">in case of 1 visitor:</label>
									<input
										type="text"
										name="vc_human_viewers_text_1"
										id="vc_human_viewers_text_1"
										value="<?= get_option('vc_human_viewers_text_1') ?>"
									/>
									<em>e.g., "visitor"</em>
							</p>
							<p>&mdash;
									<label for="vc_human_viewers_text_many">in case of many visitors:</label>
									<input
										type="text"
										name="vc_human_viewers_text_many"
										id="vc_human_viewers_text_many"
										value="<?= get_option('vc_human_viewers_text_many') ?>"
									/>
									<em>e.g., "visitors"</em>
							</p>
						</li>
					</ul>
				</fieldset></p>
				<p><fieldset name="wp_admin_options">
					<legend><strong>Additional options</strong></legend>
					<ul>
						<li id="feature_11">Display stats on posts' management page
							<p style="background-color:#f0f8ff;">
								<input
									type="radio"
									name="vc_show_in_posts_listing"
									id="vc_spil_yeah"
									value="1"
									<?php if(1 == get_option('vc_show_in_posts_listing')) echo 'checked="checked"'; ?>
								/>
								<label for="vc_spil_yeah">Of course.</label>
							</p>
							<p style="background-color:#f0f8ff;">
								<input
									type="radio"
									name="vc_show_in_posts_listing"
									id="vc_spil_nope"
									value="0"
									<?php if(1 != get_option('vc_show_in_posts_listing')) echo 'checked="checked"'; ?>
								/>
								<label for="vc_spil_nope">No way.</label>
							</p>
						</li>
					</ul>
				</fieldset></p>
				<p><fieldset name="vc_cmd_line">
					<label for="vc_command_line" style="color:gray;"><strong>cmd&gt;</strong></label>
					<input
						type="text"
						name="vc_command_line"
						id="vc_command_line"
						value="<?= get_option('vc_command_line') ?>"
						style="width: 400px;"
					/>
				</fieldset></p>
				<hr/>
				<p>
				<a href="http://blog.cerebrate.ru/vc/" target="_blank" title="VC's home page">Views Counter v.<?= $vc_version ?></a>. Copyright &copy; <a href="http://blog.cerebrate.ru/" target="_blank" title="Opens in new window">Cryonyx</a>, 2006 - Today.
				Thank you for using.
				</p>
				<div class="submit">
					<input type="submit" name="info_update" value="<?php _e('Update options', 'Localization name') ?>" />
				</div>
			</form>
		</div>
