<?php

	function vc_install()

	{

		global $table_prefix, $wpdb;

 		$table_name = $table_prefix . "vc_data";

 		if($wpdb->get_var("show tables like '$table_name'") != $table_name)

 		{

 			VC_System::logThis(0, "Creating table '$table_name'");

 			//	Look there for correct syntax: http://codex.wordpress.org/Creating_Tables_with_Plugins

			$sql = <<<HERE

CREATE TABLE IF NOT EXISTS $table_name (

id INT(11) NOT NULL PRIMARY KEY,

data LONGTEXT NOT NULL

)

HERE;



			require_once(ABSPATH . 'wp-admin/upgrade-functions.php');

			dbDelta($sql);



			if(!get_settings('vc_tag')) {

				update_option('vc_tag', "p");

			}

			if(!get_settings('vc_lang')) {

				update_option('vc_lang', "en");

			}

			if(!get_settings('vc_text_before')) {

				update_option('vc_text_before', "Viewed");

			}

			if(!get_settings('vc_human_count_text_1')) {

				update_option('vc_human_count_text_1', "time");

			}

			if(!get_settings('vc_human_count_text_many')) {

				update_option('vc_human_count_text_many', "times");

			}

			if(!get_settings('vc_preposition')) {

				update_option('vc_preposition', 'by');

			}

			if(!get_settings('vc_display_views')) {

				update_option('vc_display_views', 1);

			}

			if(!get_settings('vc_human_viewers_text_1')) {

				update_option('vc_human_viewers_text_1', "viewer");

			}

			if(!get_settings('vc_human_viewers_text_many')) {

				update_option('vc_human_viewers_text_many', "viewers");

			}

			if(!get_settings('vc_display_icon')) {

				update_option('vc_display_icon', '0');

			}

			

			update_option('vc_version', $vc_version);

 		}

	}

	

	function vc_get_stats($text_before = 'Viewed', $human_count_text = 'times', $human_ct_function = NULL, $preposition = 'by', $human_viewers_text = 'visitors', $human_vt_function = NULL, $with_icon = 0)

	{

		global $vc_options, $vc_param;

		

		if($vc_param->assertEquals('migration_in_process', 1)) return "";

		

		if($vc_param->assertEquals('display_views', 1)) return "";

		

		$vc_options = new VC_ParamMaster(1);

		$vc_options->set('text_before', $text_before);

		$vc_options->set('human_ct', $human_count_text);

		$vc_options->set('human_ct_function', $human_ct_function);

		$vc_options->set('preposition', $preposition);

		$vc_options->set('human_vt', $human_viewers_text);

		$vc_options->set('human_vt_function', $human_vt_function);

		$vc_options->set('with_icon', $with_icon);



		$counter = new VC_Counter();

		return $counter->increase(NULL);

	}

	

	function vc_get_icon()

	{

		global $vc_path, $vc_version;

		$retval  = "<a href='http://blog.cerebrate.ru/vc/' target='_blank' alt='VC' title='This site proudly uses Views Counter v." . $vc_version . "'>";

		$retval .= "<img src='" . $vc_path . "vc.gif' alt='Views Counter v." . $vc_version . "' border='0' class='vc_icon' />";

		$retval .= "</a>";

		return $retval;

	}

	

	function vcImgStyle () {

		echo "\t\t<style type=\"text/css\">

\t\t<!--

\t\t\t/* VC Image style */

\t\t\ta img.vc_icon, a:hover img.vc_icon{	text-decoration:none;	border: 0px; vertical-align: middle; position:relative; top:-2px;}

\t\t-->

\t\t</style>\n";

	}

	

	function vcIncrease($content) {

		global $vc_param;



		if($vc_param->assertEquals('migration_in_process', 1)) return $content;



		$counter = new VC_Counter();

		$content = $counter->increase($content);

		return $content;

	}

?>
