<?php
	/*
	Plugin Name: Views Counter
	Version: 0.10
	Plugin URI: http://blog.cerebrate.ru/vc/
	Description: Views Counter module tracks views of current post
	Author: Cryonyx
	Author URI: http://blog.cerebrate.ru/

	Copyright 2006 Cryonyx  (e-mail : cryonyx@yandex.ru)
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  Note: See the copy in your 'vc/license.txt' file in your plugins directory.
	*/
	
	//	Main class of VC
	require_once(dirname(__FILE__) . "/vc.class.php");
	
	$vc_version = "0.10";
	$vc_options = NULL;
	$vc_cmd		= explode(" ", get_settings('vc_command_line'));
	$vc_param	= new VC_ParamMaster();
	$vc_path    = get_bloginfo('wpurl') . '/wp-content/plugins/vc/';
	
	//	All support functions
	include_once(dirname(__FILE__) . "/vc.func.php");
	
	//	Hooks
	add_filter("the_content", "vcIncrease");
	add_action('activate_vc/viewscounter.php','vc_install');
	add_action('admin_menu', array('VC_System','add_pages'));
	add_filter('manage_posts_columns', array('VC_System', 'add_header_to_post_list'), 10, 1);
	add_action('manage_posts_custom_column', array('VC_System','add_stats_to_post_list'), 10, 2);
	add_action('wp_head', 'vcImgStyle');
	/*
	TODO:
+	1. Store all VC parameters to global variable
-	2. Create cloud of the most popular posts
+	3. Allow output forming basing on command line
+	4. Widen the set of PRO commands
+	5. Refactory source code
+	6. Add logger functionality
+	7. Remove annoying CSS from RSS feed
+	8. Add log strings
+	9. Change links to site
	*/
?>
